'
'  pb_mem.bas
'
'  DESCRIPTION
'     Power Basic memory allocation routines.
'     By Don Dickinson
'     ddickinson@usinternet.com
'     Sept, 2000
'
'  AUTHOR
'     Don Dickinson
'     don@greatwebdivide.com
'     http://dickinson.basicguru.com
'
'  LICENSE and DISCLAIMER
'     Hereby Public Domain
'
'     Use this code as you see fit. By using or compiling this code or derivative
'     thereof, you are consenting to the hold the author, Don Dickinson, harmless
'     for all effects or side-effects its use. This code works great for me,
'     but you are using it at your own risk.
'
'  DEPENDS ON
'     no other modules. some win32api.inc functions are conditionally
'     compiled here if they're not already defined.
'
'  FUNCTIONS
'     function GetMem ( ByVal howMuchMemory as Long ) as Long
'     sub FreeMem ( ByVal memoryHandle as Long )
'     sub AllocMem ( pMem as Long, iBytes as Long )
'     function isNt() as Long
'     Function GetAsciiz ( Byval sData as String ) as DWord
'     Function zToString ( zString as Asciiz PTR ) as String
'     function binToString ( pData as Long, ByVal iLen as Long ) as String
'     function GetPointer ( sString as String ) as Long
'
#If Not %def(%PB_MEM_BAS)
%PB_MEM_BAS = 1

'- I assume that if %GMEM_FIXED isn't defined, then
'  none of the windows api is included (win32api.inc)
'  so I declare everything that's needed by this module.
'
#if not %def(%GMEM_FIXED)
   %GMEM_FIXED                                  = &H0
   %GMEM_MOVEABLE                               = &H2
   %GMEM_NOCOMPACT                              = &H10
   %GMEM_NODISCARD                              = &H20
   %GMEM_ZEROINIT                               = &H40
   %GMEM_MODIFY                                 = &H80
   %GMEM_DISCARDABLE                            = &H100
   %GMEM_NOT_BANKED                             = &H1000
   %GMEM_SHARE                                  = &H2000
   %GMEM_DDESHARE                               = &H2000
   %GMEM_NOTIFY                                 = &H4000
   %GMEM_LOWER                                  = %GMEM_NOT_BANKED
   %GMEM_VALID_FLAGS                            = &H7F72
   %GMEM_INVALID_HANDLE                         = &H8000
   Declare Function GlobalAlloc Lib "KERNEL32.DLL" Alias "GlobalAlloc" _
         ( ByVal wFlags As Long, ByVal dwBytes As Long) As Long
   Declare Function GlobalFree Lib "KERNEL32.DLL" Alias "GlobalFree" _
         ( ByVal hMem As Long) As Long

#endif

#if %def(%DEBUG_PB_MEM_BAS)
Global g_totalAlloc as Quad
Global g_countAlloc as Quad
Global g_totalFreed as Quad
Global g_countFreed as Quad
#endif

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  isNt
'
'  Returns %true if the os is nt/2000pro, %false if not
'  I don't know what it returns on an XP Home or Pro box.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function isNt alias "isNt" export as Long

   dim tOsVersion AS OSVERSIONINFO

   tOsVersion.dwOSVersionInfoSize = sizeof(tOsVersion)
   if GetVersionEx(tOsVersion) THEN
      if tOsVersion.dwPlatformId  = %VER_PLATFORM_WIN32_NT then
         function = %true
      else
         function = %false
      end if
   else
      function = %false
   end if

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  GetMem
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Function GetMem Alias "GetMem" _
      (ByVal iBytes As Long) Export As Long

   #if %def(%DEBUG_PB_MEM_BAS)
   Dim iReturn as Long

   g_totalAlloc = g_totalAlloc + iBytes
   incr g_countAlloc
   iReturn = GlobalAlloc(%GMEM_FIXED or %GMEM_ZEROINIT, iBytes)
   if iReturn = 0 then
      stdout "GetMem FAILURE"
      iReturn = GlobalAlloc(%GMEM_FIXED or %GMEM_ZEROINIT, iBytes)
      if iReturn = 0 then
         stdout "GetMem FAILURE AGAIN"
      else
         stdout "Success this time"
         function = iReturn
      end if
      waitkey$
   else
      function = iReturn
   end if
   #else
   Function = GlobalAlloc(%GMEM_FIXED or %GMEM_ZEROINIT, iBytes)
   #endif

End Function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  AllocMem
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Sub AllocMem alias "AllocMem" ( pMem as Long, iBytes as Long ) export
   #if %def(%DEBUG_PB_MEM_BAS)
   Dim iReturn as Long

   g_totalAlloc = g_totalAlloc + iBytes
   incr g_countAlloc
   iReturn = GlobalAlloc(%GMEM_FIXED or %GMEM_ZEROINIT, iBytes)
   if iReturn = 0 then
      stdout "GetMem FAILURE"
      pMem = GlobalAlloc(%GMEM_FIXED or %GMEM_ZEROINIT, iBytes)
      if pMem = 0 then
         stdout "GetMem FAILURE AGAIN"
      else
         stdout "Success this time"
      end if
      waitkey$
   else
      function = pMem
   end if
   #else
   pMem = GlobalAlloc(%GMEM_FIXED or %GMEM_ZEROINIT, iBytes)
   #endif

end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  FreeMem
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Sub FreeMem Alias "FreeMem" _
      (ByVal ptrMem As Long) Export

   #if %def(%DEBUG_PB_MEM_BAS)
   g_totalFreed = g_totalFreed + GlobalSize(ptrMem)
   incr g_countFreed
   #endif
   If ptrMem Then
      GlobalFree ptrMem
   End If

End Sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  GetAsciiz
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Function GetAsciiz Alias "GetAsciiz" _
      (Byval sData as String) Export as DWord

   Dim ptrData as Asciiz Ptr

   ptrData = 0
   if len(sData) > 0 then
      ptrData = GetMem(len(sData) + 1)
      if ptrData then
         @ptrData = sData
      end if
   end if
   Function = ptrData

End Function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  zToString
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Function zToString Alias "zToString" _
      ( zString as Asciiz PTR ) as String

   if zString = 0 then
      Function = ""
   else
      Function = @zString
   end if

End Function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  binToString
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function binToString Alias "binToString" _
      ( pData as Long, ByVal iLen as Long ) as String

   Dim iPos as Long
   Dim pInput as Byte Ptr
   Dim pOutput as Byte Ptr
   Dim sTemp as String

   if (iLen < 1) or (pData = 0) then
      function = ""
      exit function
   end if

   sTemp = String$(iLen, $nul)
   pOutput = StrPtr(sTemp)
   pInput = pData
   do
      @pOutput[iPos] = @pInput[iPos]
      incr iPos
      if iPos >= iLen then exit do
   loop
   function = sTemp

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  stringToPointer
'
'  Gets memory to hold a binary string in memory, then copies the
'  string into that memory. Note, this does not null terminate the
'  string and allows binary data to be copied.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function GetPointer Alias "GetPointer" _
      ( sString as String ) as Long

   Dim iLen as Long
   Dim iPos as Long
   Dim pOutput as Byte Ptr
   Dim pInput as Byte Ptr

   iLen = len(sString)
   if iLen < 1 then
      function = 0
      exit function
   end if

   pInput = strptr(sString)
   pOutput = GetMem(len(sString))

   if pOutput then
      iPos = 0
      do
         @pOutput[iPos] = @pInput[iPos]
         incr iPos
         if iPos >= iLen then exit do
      loop
   end if

   function = pOutput

end function

#endif
