'
'  pb_mtx.bas
'
'  Mutex wrappers for use in local locking
'  PUBLIC DOMAIN CODE
'  from Don Dickinson
'  don@greatwebdivide.com
'
#if not %def(%PB_MTX_BAS)
%PB_MTX_BAS = 1
#include "pb_secur.bas"

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mtxLock
'
'  Returns %true if the mutex named sMutexName is able to be owned.
'  If not, it returns %false.
'
'  iTimeout_ms is the timeout value in milliseconds. It can be set
'  to %INFINITE to wait forever or 0 to return instantly.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mtxLock alias "mtxLock" _
      (ByVal sMutexName as String, ByVal iTimeout_ms as Long ) _
       export as Long

   Dim hMutex as Long

   '- Back slashes are not allowed so I replace
   '  with a ":"
   '
   Replace "\" with ":" in sMutexName

   hMutex = CreateMutex(ByVal %null, 0, sMutexName + $nul)
   if hMutex = 0 then
      hMutex = OpenMutex(%MUTEX_ALL_ACCESS, 0, sMutexName + $nul)
   end if

   if hMutex = 0 then
      function = %false
   else
      select case WaitForSingleObject(hMutex, iTimeout_ms)
         case %WAIT_ABANDONED, %WAIT_OBJECT_0
            function = %true
         case else      '%WAIT_FAILED, %WAIT_TIMEOUT
            function = %false
      end select
   end if

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mtxLock2
'
'  Like mtxLock, but gets a security descriptor
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mtxLock2 alias "mtxLock2" _
      (ByVal sMutexName as String, ByVal iTimeout_ms as Long ) _
       export as Long

   Dim hMutex as Long
   Dim pSid as Long
   Dim pACL as Long
   Dim rSecurity as SECURITY_ATTRIBUTES
   Dim rSecDesc as SECURITY_DESCRIPTOR

   '- Back slashes are not allowed so I replace
   '  with a ":"
   '
   Replace "\" with ":" in sMutexName

   '- Get full rights
   if isNt() = %false then
      hMutex = CreateMutex(ByVal %null, 0, sMutexName + $nul)

   elseif getGlobalSecurity(rSecurity, rSecDesc, pSid, pACL) = %false then
      hMutex = CreateMutex(ByVal %null, 0, sMutexName + $nul)

   else
      hMutex = CreateMutex(rSecurity, 0, sMutexName + $nul)
   end if

   if hMutex = 0 then
      hMutex = OpenMutex(%MUTEX_ALL_ACCESS, 0, sMutexName + $nul)
   end if

   if hMutex = 0 then
      function = %false
   else
      select case WaitForSingleObject(hMutex, iTimeout_ms)
         case %WAIT_ABANDONED, %WAIT_OBJECT_0
            function = %true
         case else      '%WAIT_FAILED, %WAIT_TIMEOUT
            function = %false
      end select
   end if

   if pSid then FreeSid pSid
   if pAcl then FreeMem pAcl

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mtxUnlock
'
'  Frees the mutex obtained with mtxLock - reference the mutex by name
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mtxUnlock alias "mtxUnlock" _
      ( ByVal sMutexName as String ) export as Long

   Dim hMutex as Long

   '- Just as in mtxLock, back slashes are not
   '  allowed so I replace with a ":"
   '
   Replace "\" with ":" in sMutexName

   hMutex = OpenMutex(%MUTEX_ALL_ACCESS, 0, sMutexName + $nul)
   if hMutex then
      ReleaseMutex hMutex
   end if

end function
#endif
