'
'  pb_mysql.bas
'
'  mysql wrapper functions
'
'	LICENSE
'		Hereby public domain
'
'	AUTHOR
'		Don Dickinson
'		don@greatwebdivide.com
'		http://www.greatwebdivide.com
'
'  DEPENDS ON
'		pb_mysql.inc - translation of the mysql header files
'     pb_mem.bas, pb_mtx.bas, and dd_link.bas modules
'     from Don Dickinson
'
'     pb_mysql.inc
'     the raw declares for libmysql.dll
'
'  HISTORY
'     8-27-2003 DD
'     Module created and initial testing done.
'
'  NOTES
'  >> If you define %PB_MYSQL_DYNAMIC_LOAD your
'     program will not be dependent on libmysql.dll
'     being on the sytsem, but you must call myInit
'     when your program starts and myFree just before
'     it ends to load and unload the mysql library.
'
#if not %def(%PB_MYSQL_BAS)
%PB_MYSQL_BAS = 1

#include "pb_mysql.inc"
#include "pb_mem.bas"         ' memory allocation
#include "pb_mtx.bas"         ' mutex
#include "dd_link.bas"        ' linked lists

$MYSQL_MUTEX = "dd_mysql_bas_mutex"
%MYSQL_DEFAULT_PORT = 3306

global g_mysql_errors as long

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myInit
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myInit() as long

   function = mysql_init_dynamic()

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myFree
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sub myFree()

   mysql_free_dynamic

end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myError
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myError alias "myError" ( byval pMySQL as long ) export as string

   if mtxLock($MYSQL_MUTEX, 1000) then
      function = llDataByName(g_mysql_errors, format$(pMySQL))
      mtxUnlock $MYSQL_MUTEX
   else
      function = "Unable to access exact error message."
   end if

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mySetError
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sub mySetError alias "mySetError" _
      ( byval pMySQL as long, byval sMsg as string )

   if mtxLock($MYSQL_MUTEX, 1000) then
      if g_mysql_errors = 0 then
         g_mysql_errors = llAdd(0, format$(pMySQL), sMsg)
      else
         llUpdateByName g_mysql_errors, format$(pMySQL), sMsg
      end if
      mtxUnlock $MYSQL_MUTEX
   end if

end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myConnect
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myConnect alias "myConnect" _
      ( byval sServer as string, byval DB as string, _
        byval sUser as string, byval sPassword as string, _
        byval dwPort as dword, byval dwFlags as dword ) export as long

   dim iReturn as long
   dim pConnect as long

   mySetError 0, ""
   if dwPort = 0 then dwPort = %MYSQL_DEFAULT_PORT

   '- Initialize the structure
   pConnect = mysql_init(byval %null)
   if pConnect = 0 then
      mySetError 0, "mysql_init failed"
      function = 0
      exit function
   end if

   iReturn = mysql_real_connect ( pConnect, sServer + $nul, _
         sUser + $nul, sPassword + $nul, db + $nul, _
         dwPort, byval %null, dwFlags )
   if iReturn = 0 then
      mySetError 0, "Unable to connect with server."
   end if

   function = iReturn

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myDisconnect
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myDisconnect alias "myDisconnect" _
      ( byval pMySQL as long ) export as long

   mysql_close pMySQL

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mySQLUse
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myUse alias "myUse" _
      ( byval pMySQL as long, byval DB as string ) export as long

   if mysql_select_db(pMySQL, db + $nul) = 0 then
      function = %true
   else
      function = %false
   end if

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myExecute
'
'  Returns a pointer to the result set
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myExecute alias "myExecute" _
      ( byval pMySQL as long, byval sSQL as string ) export as long

   dim iResult as long
   dim pResultSet as long

   mySetError pMySQL, ""
   iResult = mysql_real_query(pMySQL, sSQL + $nul, len(sSQL))
   if iResult = 0 then
      pResultSet = mysql_use_result(pMySQL)
      if pResultSet = 0 then
         if mysql_field_count(pMySQL) = 0 then
            mySetError pMySql, "Query doesn't return any columns"
            function = 0
         else
            mySetError pMySql, "Error accessing results"
            function = 0
         end if
      else
         function = pResultSet
      end if

   else
      mySetError pMySQL, "Query failed"
      function = 0

   end if

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myExecuteDone
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myExecuteDone alias "myExecuteDone" _
      ( byval pResultSet as long ) export as long

   mysql_free_result byval pResultSet

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myExecuteNoReturn
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myExecuteNoReturn alias "myExecuteNoReturn" _
      ( byval pMySQL as long, byval sSQL as string ) export as long

   dim iResult as long
   dim pResultSet as long

   mySetError pMySQL, ""
   iResult = mysql_real_query(pMySQL, sSQL + $nul, len(sSQL))
   if iResult = 0 then
      pResultSet = mysql_store_result(pMySQL)
      if pResultSet = 0 then
         if mysql_field_count(pMySQL) = 0 then
            function = %true
         else
            mySetError pMySql, "Error accessing results"
            function = %false
         end if
      else
         mysql_free_result byval pResultSet
         function = %true
      end if

   else
      mySetError pMySQL, "Query failed"
      function = %false

   end if

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myNextRow
'
'  Returns a pointer to the field data on success.
'  Returns %null on failure or if there are no more rows.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myNextRow alias "myNextRow" _
      ( byval pMySQL as long, byval pResultSet as long ) as long

   dim i as long
   dim iCount as long
   dim iLen as long
   dim iOffset as long
   dim dwLengths as dword ptr
   dim pRow as dword ptr
   dim pFields as MYSQL_FIELD PTR
   dim sName as string
   dim sValue as string
   dim pResult as long

   pRow = mysql_fetch_row ( byval pResultSet )
   if pRow = 0 then
      function = %false
      exit function
   end if

   iCount = mysql_field_count(pMySQL)
   dwLengths = mysql_fetch_lengths(byval pResultSet)
   pFields = mysql_fetch_fields(byval pResultSet)
   pResult = llAdd(0, "dd_mysql_field_types", "")

   iOffset = 0
   for i = 1 to iCount
      iLen = @dwLengths[i-1]
      if iLen = 0 then
         sValue = ""
      else
         sValue = space$(iLen)
         copyMemory byval strptr(sValue), byval (@pRow + iOffset), iLen
      end if

      sName = trim$(lcase$(zToString(@pFields[i-1].zName)))
      llAdd pResult, sName, sValue
      iOffset = iOffset + iLen + 1
   next i

   function = pResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myField
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myField alias "myField" _
      ( byval pRow as long, byval fieldName as string ) export as string

   function = llDataByName(pRow, lcase$(fieldName))

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myFieldInt
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myFieldInt alias "myFieldInt" _
      ( byval pRow as long, byval fieldName as string ) export as long

   dim sReturn as string

   sReturn = myField(pRow, fieldName)
   function = val(sReturn)

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myFieldDouble
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myFieldDouble alias "myFieldDouble" _
      ( byval pRow as long, byval fieldName as string ) export as double

   dim sReturn as string

   sReturn = myField(pRow, fieldName)
   replace any ",$#" with "   " in sReturn
   replace " " with "" in sReturn

   function = val(sReturn)

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myFieldDate
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myFieldDate alias "myFieldDate" _
      ( byval pRow as long, byval fieldName as string ) export as string

   dim sDate as string

   sDate = myField(pRow, fieldName)
   function = mid$(sDate, 6, 2) + "-" + mid$(sDate, 9, 2) + "-" + left$(sDate, 4)

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myFieldTime
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myFieldTime alias "myFieldTime" _
      ( byval pRow as long, byval fieldName as string ) export as string

   dim sTime as string

   sTime = myField(pRow, fieldName)
   function = right$(sTime, 8)

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  myFreeFields
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sub myFreeFields alias "myFreeFields" ( byval pFields as long )
   llFree pFields
end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	myCreateDB
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function myCreateDB alias "myCreateDB" _
		( byval pMySql as long, byval sDB as string ) export as long

	mySetError pMySQL, ""
	if mysql_create_db(pMySQL, sDB + $nul) = 0 then
		function = %true
	else
		mySetError pMySQL, "Unable to create database '" + sDB + "'"
		function = %false
	end if

end function

#endif
