'
'	pb_mysql.inc
'
'	AUTHOR
'		Don Dickinson
'		don@greatwebdivide.com
'		http://www.greatwebdivide.com
'
'	LICENSE
'		Public Domain
'
'  CREDITS
'     some help gained by studying the mysql.inc file
'     created by Florent Heyworth and modified by
'     Mike Trader. pb_mysql.inc and pb_mysql.bas
'     were entirely created from scratch by
'     me with some study of their work.
'
'  HISTORY
'  >> 8-26-2003 DD
'     Module created
'  >> 8-27-2003 DD
'     Added dynamic load (see %PB_MYSQL_DYNAMIC_LOAD)
'
'  NOTES:
'  >> See pb_mysql.bas for the real wrappers, this module
'     contains the raw dll declares and dynamic load wrappers.
'
'  >> if you define the equate: %PB_MYSQL_DYNAMIC_LOAD
'     in your program, this module will not be
'     dependent on libmysql.dll being present. The library
'     will be loaded when you call myInit (in pb_mysql.bas)
'     If you define this constant then must call myInit
'     first thing when your program starts. If it returns
'     0 then libmysql.dll cannot be found. It it returns
'     non-zero, then the library was loaded. Just before
'     your program exists, you need to call myFree
'     (again in pb_mysql.bas) to unload the library.
'
#if not %def(%PB_MYSQL_INC)
%PB_MYSQL_INC = 1
type MEM_ROOT
	pFree as long
	pUsed as long
	pPreAlloc as long
	min_alloc as dword
	block_size as dword
	error_handler as long
end type

type MYSQL_RES
	row_count as dword
	field_count as dword
	current_field as dword
	pFields as long
	pData as long
	pRows as long
	field_alloc as MEM_ROOT
	pRow as long
	pCurrent_row as long
	pLengths as long
	pHandle as long
	myeof as long
end type

type MYSQL_FIELD
    zName as asciiz ptr
    zTable as asciiz ptr
    zDefault as asciiz ptr
    iFieldType as long
    dwLength as dword
    dwMaxLength as dword
    dwFlags as dword
    dwDecimals as dword
END TYPE

#if %def(%PB_MYSQL_DYNAMIC_LOAD)
global g_mysql_lib as long

declare function template_mysql_affected_rows _
      ( byval ptMysql as long ) as dword
declare function template_mysql_change_user _
		( byval ptMysql as long, zUser as asciiz, zPass as asciiz, _
		  zDB as asciiz ) as long
declare function template_mysql_character_set_name _
		( ptMySql as long ) as dword
declare sub template_mysql_close _
      ( byval ptMYSQL  as long )
declare function template_mysql_create_db _
		( byval ptMySql as long, zDB as asciiz ) as long
declare sub template_mysql_data_seek _
		( iResult as MYSQL_RES, byval iOffset as long )
declare sub template_mysql_debug _
		( zDebug as asciiz )
declare function template_mysql_drop_db _
		( byval ptMySql as long, zDB as asciiz ) as long
declare function template_mysql_dump_debug_info _
		( byval ptMySql as long ) as long
declare function template_mysql_eof _
		( rResult as MYSQL_RES ) as long
declare function template_mysql_errno _
		( byval pMySql as long ) as long
declare function template_mysql_error _
		( byval pMySql as long ) as long
declare function template_mysql_fetch_field _
		( rResult as MYSQL_RES ) as dword
declare function template_mysql_fetch_fields _
		( rResult as MYSQL_RES ) as dword
declare function template_mysql_fetch_field_direct _
		( rResult as MYSQL_RES, byval fieldnr as dword ) as dword
declare function template_mysql_fetch_lengths _
		( rResult as MYSQL_RES ) as dword
declare function template_mysql_fetch_row _
		( rResult as MYSQL_RES ) as long
declare function template_mysql_field_count _
		( byval pMySql as long ) as dword
declare function template_mysql_field_seek _
		( byval pMySql as long, byval iOffset as long ) as long
declare function template_mysql_field_tell _
		( rResult as MYSQL_RES ) as long
declare sub template_mysql_free_result _
		( rResult as MYSQL_RES )
declare function template_mysql_get_client_info () as dword
declare function template_mysql_get_server_version _
		( byval pMysql as long ) as dword
declare function template_mysql_get_host_info _
		( byval pMysql as long ) as dword
declare function template_mysql_get_proto_info _
		( byval pMySql as long ) as dword
declare function template_mysql_get_server_info _
		( byval pMySql as long ) as dword
declare function template_mysql_info _
		( byval pMysql as long ) as dword
declare function template_mysql_init _
      ( byval ptMYSQL  as long ) as long
declare function template_mysql_insert_id _
		( byval ptMySql as long ) as dword
declare function template_mysql_kill _
		( byval pMySql as long, byval pid as dword ) as long
declare function template_mysql_list_dbs _
		( byval pMySql as long, zWild as asciiz ) as long
declare function template_mysql_list_fields _
		( byval pMySql as long, zTable as asciiz, zWild as asciiz ) as long
declare function template_mysql_list_processes _
		( byval pMySql as long ) as long
declare function template_mysql_list_tables _
		( byval pMySql as long, zWild as asciiz ) as long
declare function template_mysql_num_fields _
		( rResult as MYSQL_RES ) as long
declare function template_mysql_num_rows _
		( rResult as MYSQL_RES ) as long
declare function template_mysql_options _
      ( byval ptMYSQL as long, byval iOption as long, _
        szArg as any) as long
declare function template_mysql_ping _
      ( byval pMYSQL  as long ) as long
declare function template_mysql_query _
		( byval pMySql as long, zQuery as asciiz ) as long
declare function template_mysql_real_connect _
      ( byval pMySql as long, zHost as asciiz, zUserName as asciiz, _
        zPassword as asciiz, zDBName as asciiz, byval iPortNm as long, _
        zSocketName as asciiz, byval iFlags as long ) as long
declare function template_mysql_real_escape_string _
		( byval pMySql as long, zTo as asciiz, zFrom as asciiz, _
		  byval iLen as long ) as long
declare function template_mysql_real_query _
		( byval pMySql as long, zQuery as asciiz, byval iLen as long ) as long
declare function template_mysql_reload _
		( byval pMySql as long ) as long
declare function template_mysql_row_seek _
		( rResult as MYSQL_RES, byval iOffset as long ) as long
declare function template_mysql_row_tell _
		( rResult as MYSQL_RES ) as long
declare function template_mysql_select_db _
		( byval pMySql as long, zDB as asciiz ) as long
declare function template_mysql_shutdown _
		( byval pMySql as long ) as long
declare function template_mysql_stat _
		( byval pMySql as long ) as long
declare function template_mysql_store_result _
		( byval pMySql as long ) as long
declare function template_mysql_thread_id _
		( byval pMySql as long ) as long
declare function template_mysql_use_result _
		( byval pMySql as long ) as long
declare function template_mysql_commit _
		( byval pMySql as long ) as long
declare function template_mysql_rollback _
		( byval pMySql as long ) as long
declare function template_mysql_autocommit _
		( byval pMySql as long, byval bMode as long ) as long
declare function template_mysql_more_results _
		( byval pMySql as long ) as long
declare function template_mysql_next_result _
		( byval pMySql as long ) as long

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_init_dynamic
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_init_dynamic alias "mysql_init_dynamic" () as long

   if g_mysql_lib = 0 then
      g_mysql_lib = loadLibrary("libmysql.dll")
      if g_mysql_lib = 0 then
         function = %false
      else
         function = %true
      end if
   else
      function = %true
   end if

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_free_dynamic
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sub mysql_free_dynamic alias "mysql_free_dynamic"

   if g_mysql_lib then
      freeLibrary g_mysql_lib
      g_mysql_lib = 0
   end if

end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_get_function
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_get_function alias "mysql_get_function" _
      ( functionName as string ) as long

   if g_mysql_lib = 0 then
      mysql_init_dynamic
      if g_mysql_lib = 0 then
         function = 0
         exit function
      end if
   end if

   function = getProcAddress(g_mysql_lib, functionName + $nul)

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_affected_rows
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_affected_rows alias "mysql_affected_rows" _
		( byval ptMysql as long ) as dword

   dim hFunc as long
   dim dwResult as long

   hFunc = mysql_get_function("mysql_affected_rows")
   if hFunc then
      call dword hFunc using template_mysql_affected_rows ( ptMysql ) to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_change_user
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_change_user alias "mysql_change_user" _
		( byval ptMysql as long, zUser as asciiz, zPass as asciiz, _
		  zDB as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function("mysql_change_user")
   if hFunc then
      call dword hFunc using _
            template_mysql_change_user ( ptMysql, zUser, zPass, zDB ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_character_set_name
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_character_set_name alias "mysql_character_set_name" _
		( ptMySql as long ) as dword

   dim hFunc as long
   dim dwResult as long

   hFunc = mysql_get_function("mysql_character_set_name")
   if hFunc then
      call dword hFunc using _
            template_mysql_character_set_name ( ptMysql ) _
            to dwResult
   end if

   function = dwResult


end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_close
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sub mysql_close alias "mysql_close" _
      ( byval ptMYSQL  as long )

   dim hFunc as long

   hFunc = mysql_get_function("mysql_close")
   if hFunc then
      call dword hFunc using template_mysql_close ( ptMySQL )
   end if

end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_create_db
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_create_db alias "mysql_create_db" _
		( byval ptMySql as long, zDB as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function("mysql_create_db")
   if hFunc then
      call dword hFunc using _
            template_mysql_create_db ( ptMysql, zDB ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_data_seek
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sub mysql_data_seek alias "mysql_data_seek" _
		( rResult as MYSQL_RES, byval iOffset as long )

   dim hFunc as long

   hFunc = mysql_get_function("mysql_data_seek")
   if hFunc then
      call dword hFunc using template_mysql_data_seek ( rResult, iOffset )
   end if

end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_debug
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sub mysql_debug alias "mysql_debug" _
		( zDebug as asciiz )

   dim hFunc as long

   hFunc = mysql_get_function("mysql_debug")
   if hFunc then
      call dword hFunc using template_mysql_debug ( zDebug )
   end if

end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_drop_db
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_drop_db alias "mysql_drop_db" _
		( byval ptMySql as long, zDB as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function("mysql_drop_db")
   if hFunc then
      call dword hFunc _
            using template_mysql_drop_db ( ptMySql, zDB ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_dump_debug_info
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_dump_debug_info alias "mysql_dump_debug_info" _
		( byval ptMySql as long ) as long

	dim hFunc as long
	dim iResult as long

	hFunc = mysql_get_function("mysql_dump_debug_info")
	if hFunc then
	   call dword hFunc _
	         using template_mysql_dump_debug_info ( ptMySQL ) _
	         to iResult
	end if

	function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_eof
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_eof alias "mysql_eof" _
		( rResult as MYSQL_RES ) as long

   dim hFunc as long
   dim iResult as long

	hFunc = mysql_get_function("mysql_eof")
	if hFunc then
	   call dword hFunc _
	         using template_mysql_eof ( rResult ) _
	         to iResult
	end if

	function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_errno
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_errno alias "mysql_errno" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

	hFunc = mysql_get_function("mysql_errno")
	if hFunc then
	   call dword hFunc _
	         using template_mysql_errno ( pMySql ) _
	         to iResult
	end if

	function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_error
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_error alias "mysql_error" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

	hFunc = mysql_get_function("mysql_error")
	if hFunc then
	   call dword hFunc _
	         using template_mysql_error ( pMySql ) _
	         to iResult
	end if

	function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_fetch_field
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_fetch_field alias "mysql_fetch_field" _
		( rResult as MYSQL_RES ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_fetch_field")
   if hFunc then
      call dword hFunc _
            using template_mysql_fetch_field ( rResult ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_fetch_fields
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_fetch_fields alias "mysql_fetch_fields" _
		( rResult as MYSQL_RES ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_fetch_fields")
   if hFunc then
      call dword hFunc _
            using template_mysql_fetch_fields ( rResult ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_fetch_field_direct
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_fetch_field_direct alias "mysql_fetch_field_direct" _
		( rResult as MYSQL_RES, byval fieldnr as dword ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_fetch_field_direct")
   if hFunc then
      call dword hFunc _
            using template_mysql_fetch_field_direct ( rResult, fieldnr ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_fetch_lengths
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_fetch_lengths alias "mysql_fetch_lengths" _
		( rResult as MYSQL_RES ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_fetch_lengths")
   if hFunc then
      call dword hFunc _
            using template_mysql_fetch_lengths ( rResult ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_fetch_row
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_fetch_row alias "mysql_fetch_row" _
		( rResult as MYSQL_RES ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_fetch_row")
   if hFunc then
      call dword hFunc _
            using template_mysql_fetch_row ( rResult ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_field_count
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_field_count alias "mysql_field_count" _
		( byval pMySql as long ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_field_count")
   if hFunc then
      call dword hFunc _
            using template_mysql_field_count ( pMySQL ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_field_seek
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_field_seek alias "mysql_field_seek" _
		( byval pMySql as long, byval iOffset as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_field_seek")
   if hFunc then
      call dword hFunc _
            using template_mysql_field_seek ( pMySQL, iOffset ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_field_tell
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_field_tell alias "mysql_field_tell" _
		( rResult as MYSQL_RES ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_field_tell")
   if hFunc then
      call dword hFunc _
            using template_mysql_field_tell ( rResult ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_free_result
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sub mysql_free_result alias "mysql_free_result" _
		( rResult as MYSQL_RES )

   dim hFunc as long

   hFunc = mysql_get_function ("mysql_free_result")
   if hFunc then
      call dword hFunc _
            using template_mysql_free_result ( rResult )
   end if

end sub

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_get_client_info
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_get_client_info alias "mysql_get_client_info" () as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_get_client_info")
   if hFunc then
      call dword hFunc _
            using template_mysql_get_client_info _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_get_server_version
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_get_server_version alias "mysql_get_server_version" _
		( byval pMysql as long ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_get_server_version")
   if hFunc then
      call dword hFunc _
            using template_mysql_get_server_version ( pMySQL ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_get_host_info
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_get_host_info alias "mysql_get_host_info" _
		( byval pMysql as long ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_get_host_info")
   if hFunc then
      call dword hFunc _
            using template_mysql_get_host_info ( pMySQL ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_get_proto_info
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_get_proto_info alias "mysql_get_proto_info" _
		( byval pMySql as long ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_get_proto_info")
   if hFunc then
      call dword hFunc _
            using template_mysql_get_proto_info ( pMySQL ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_get_server_info
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_get_server_info alias "mysql_get_server_info" _
		( byval pMySql as long ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_get_server_info")
   if hFunc then
      call dword hFunc _
            using template_mysql_get_server_info ( pMySQL ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_info
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_info alias "mysql_info" _
		( byval pMysql as long ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_info")
   if hFunc then
      call dword hFunc _
            using template_mysql_info ( pMySQL ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_init
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_init alias "mysql_init" _
      ( byval ptMYSQL  as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_init")
   if hFunc then
      call dword hFunc _
            using template_mysql_init ( ptMYSQL ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_insert_id
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_insert_id alias "mysql_insert_id" _
		( byval ptMySql as long ) as dword

   dim hFunc as long
   dim dwResult as dword

   hFunc = mysql_get_function ("mysql_insert_id")
   if hFunc then
      call dword hFunc _
            using template_mysql_insert_id ( ptMySql ) _
            to dwResult
   end if

   function = dwResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_kill
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_kill alias "mysql_kill" _
		( byval pMySql as long, byval pid as dword ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_kill")
   if hFunc then
      call dword hFunc _
            using template_mysql_kill ( pMySQL, pid ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_list_dbs
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_list_dbs alias "mysql_list_dbs" _
		( byval pMySql as long, zWild as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_list_dbs")
   if hFunc then
      call dword hFunc _
            using template_mysql_list_dbs ( pMySql, zWild ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_list_fields
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_list_fields alias "mysql_list_fields" _
		( byval pMySql as long, zTable as asciiz, zWild as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_list_fields")
   if hFunc then
      call dword hFunc _
            using template_mysql_list_fields ( pMySql, zTable, zWild ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_list_processes
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_list_processes alias "mysql_list_processes" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_list_processes")
   if hFunc then
      call dword hFunc _
            using template_mysql_list_processes ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_list_tables
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_list_tables alias "mysql_list_tables" _
		( byval pMySql as long, zWild as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_list_tables")
   if hFunc then
      call dword hFunc _
            using template_mysql_list_tables( pMySql, zWild ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_num_fields
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_num_fields alias "mysql_num_fields" _
		( rResult as MYSQL_RES ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_num_fields")
   if hFunc then
      call dword hFunc _
            using template_mysql_num_fields( rResult ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_num_rows
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_num_rows alias "mysql_num_rows" _
		( rResult as MYSQL_RES ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_num_rows")
   if hFunc then
      call dword hFunc _
            using template_mysql_num_rows( rResult ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_options
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_options alias "mysql_options" _
      ( byval ptMYSQL as long, byval iOption as long, _
        zArg as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_options")
   if hFunc then
      call dword hFunc _
            using template_mysql_options( ptMySQL, iOption, zArg ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_ping
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_ping alias "mysql_ping"_
      ( byval pMYSQL  as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_ping")
   if hFunc then
      call dword hFunc _
            using template_mysql_ping( pMYSQL ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_query
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_query alias "mysql_query" _
		( byval pMySql as long, zQuery as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_query")
   if hFunc then
      call dword hFunc _
            using template_mysql_query( pMYSQL, zQuery ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_real_connect
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_real_connect alias "mysql_real_connect" _
      ( byval pMySql as long, zHost as asciiz, zUserName as asciiz, _
        zPassword as asciiz, zDBName as asciiz, byval iPortNm as long, _
        zSocketName as asciiz, byval iFlags as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_real_connect")
   if hFunc then
      call dword hFunc _
            using template_mysql_real_connect( pMySql, zHost, zUserName, _
            zPassword, zDBName, iPortNm, zSocketName, iFlags ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_real_escape_string
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_real_escape_string alias "mysql_real_escape_string" _
		( byval pMySql as long, zTo as asciiz, zFrom as asciiz, _
		  byval iLen as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_real_escape_string")
   if hFunc then
      call dword hFunc _
            using template_mysql_real_escape_string ( pMySQL, zTo, _
            zFrom, iLen ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_real_query
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_real_query alias "mysql_real_query" _
		( byval pMySql as long, zQuery as asciiz, byval iLen as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_real_query")
   if hFunc then
      call dword hFunc _
            using template_mysql_real_query ( pMySQL, zQuery, iLen ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_reload
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_reload alias "mysql_reload" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_reload")
   if hFunc then
      call dword hFunc _
            using template_mysql_reload ( pMySQL ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_row_seek
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_row_seek alias "mysql_row_seek" _
		( rResult as MYSQL_RES, byval iOffset as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_row_seek")
   if hFunc then
      call dword hFunc _
            using template_mysql_row_seek ( rResult, iOffset ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_row_tell
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_row_tell alias "mysql_row_tell" _
		( rResult as MYSQL_RES ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_row_tell")
   if hFunc then
      call dword hFunc _
            using template_mysql_row_tell ( rResult ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_select_db
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_select_db alias "mysql_select_db" _
		( byval pMySql as long, zDB as asciiz ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_select_db")
   if hFunc then
      call dword hFunc _
            using template_mysql_select_db ( pMySql, zDB ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_shutdown
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_shutdown alias "mysql_shutdown" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_shutdown")
   if hFunc then
      call dword hFunc _
            using template_mysql_shutdown ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_stat
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_stat alias "mysql_stat" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_stat")
   if hFunc then
      call dword hFunc _
            using template_mysql_stat ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_store_result
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_store_result alias "mysql_store_result" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_store_result")
   if hFunc then
      call dword hFunc _
            using template_mysql_store_result ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_thread_id
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_thread_id alias "mysql_thread_id" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_thread_id")
   if hFunc then
      call dword hFunc _
            using template_mysql_thread_id ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_use_result
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_use_result alias "mysql_use_result" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_use_result")
   if hFunc then
      call dword hFunc _
            using template_mysql_use_result ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_commit
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_commit alias "mysql_commit" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_commit")
   if hFunc then
      call dword hFunc _
            using template_mysql_commit ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_rollback
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_rollback alias "mysql_rollback" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_rollback")
   if hFunc then
      call dword hFunc _
            using template_mysql_rollback ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_autocommit
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_autocommit alias "mysql_autocommit" _
		( byval pMySql as long, byval bMode as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_autocommit")
   if hFunc then
      call dword hFunc _
            using template_mysql_autocommit ( pMySql, bMode ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_more_results
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_more_results alias "mysql_more_results" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_more_results")
   if hFunc then
      call dword hFunc _
            using template_mysql_more_results ( pMySql ) _
            to iResult
   end if

   function = iResult

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  mysql_next_result
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function mysql_next_result alias "mysql_next_result" _
		( byval pMySql as long ) as long

   dim hFunc as long
   dim iResult as long

   hFunc = mysql_get_function ("mysql_next_result")
   if hFunc then
      call dword hFunc _
            using template_mysql_next_result ( pMySql ) _
            to iResult
   end if

   function = iResult
end function

#else
declare function mysql_affected_rows lib "libmysql.dll" alias "mysql_affected_rows" _
		( byval ptMysql as long ) as dword

declare function mysql_change_user lib "libmysql.dll" alias "mysql_change_user" _
		( byval ptMysql as long, zUser as asciiz, zPass as asciiz, _
		  zDB as asciiz ) as long

declare function mysql_character_set_name lib "libmysql.dll" alias "mysql_character_set_name" _
		( ptMySql as long ) as dword

declare sub mysql_close lib "libmysql.dll" alias "mysql_close" _
      ( byval ptMYSQL  as long )

declare function mysql_create_db lib "libmysql.dll" alias "mysql_create_db" _
		( byval ptMySql as long, zDB as asciiz ) as long

declare sub mysql_data_seek lib "libmysql.dll" alias "mysql_data_seek" _
		( iResult as MYSQL_RES, byval iOffset as long )

declare sub mysql_debug lib "libmysql.dll" alias "mysql_debug" _
		( zDebug as asciiz )

declare function mysql_drop_db lib "libmysql.dll" alias "mysql_drop_db" _
		( byval ptMySql as long, zDB as asciiz ) as long

declare function mysql_dump_debug_info lib "libmysql.dll" alias "mysql_dump_debug_info" _
		( byval ptMySql as long ) as long

declare function mysql_eof lib "libmysql.dll" alias "mysql_eof" _
		( rResult as MYSQL_RES ) as long

declare function mysql_errno lib "libmysql.dll" alias "mysql_errno" _
		( byval pMySql as long ) as long

declare function mysql_error lib "libmysql.dll" alias "mysql_error" _
		( byval pMySql as long ) as long

declare function mysql_fetch_field lib "libmysql.dll" alias "mysql_fetch_field" _
		( rResult as MYSQL_RES ) as dword

declare function mysql_fetch_fields lib "libmysql.dll" alias "mysql_fetch_fields" _
		( rResult as MYSQL_RES ) as dword

declare function mysql_fetch_field_direct lib "libmysql.dll" alias "mysql_fetch_field_direct" _
		( rResult as MYSQL_RES, byval fieldnr as dword ) as dword

declare function mysql_fetch_lengths lib "libmysql.dll" alias "mysql_fetch_lengths" _
		( rResult as MYSQL_RES ) as dword

declare function mysql_fetch_row lib "libmysql.dll" alias "mysql_fetch_row" _
		( rResult as MYSQL_RES ) as long

declare function mysql_field_count lib "libmysql.dll" alias "mysql_field_count" _
		( byval pMySql as long ) as dword

declare function mysql_field_seek lib "libmysql.dll" alias "mysql_field_seek" _
		( byval pMySql as long, byval iOffset as long ) as long

declare function mysql_field_tell lib "libmysql.dll" alias "mysql_field_tell" _
		( rResult as MYSQL_RES ) as long

declare sub mysql_free_result lib "libmysql.dll" alias "mysql_free_result" _
		( rResult as MYSQL_RES )

declare function mysql_get_client_info lib "libmysql.dll" alias "mysql_get_client" () as dword

declare function mysql_get_server_version lib "libmysql.dll" alias "mysql_get_server_version" _
		( byval pMysql as long ) as dword

declare function mysql_get_host_info lib "libmysql.dll" alias "mysql_get_host_info" _
		( byval pMysql as long ) as dword

declare function mysql_get_proto_info lib "libmysql.dll" alias "mysql_get_proto_info" _
		( byval pMySql as long ) as dword

declare function mysql_get_server_info lib "libmysql.dll" alias "mysql_get_server_info" _
		( byval pMySql as long ) as dword

declare function mysql_info lib "libmysql.dll" alias "mysql_info" _
		( byval pMysql as long ) as dword

declare function mysql_init lib "libmysql.dll" alias "mysql_init" _
      ( byval ptMYSQL  as long ) as long

declare function mysql_insert_id lib "libmysql.dll" alias "mysql_insert_id" _
		( byval ptMySql as long ) as dword

declare function mysql_kill lib "libmysql.dll" alias "mysql_kill" _
		( byval pMySql as long, byval pid as dword ) as long

declare function mysql_list_dbs lib "libmysql.dll" alias "mysql_list_dbs" _
		( byval pMySql as long, zWild as asciiz ) as long

declare function mysql_list_fields lib "libmysql.dll" alias "mysql_list_fields" _
		( byval pMySql as long, zTable as asciiz, zWild as asciiz ) as long

declare function mysql_list_processes lib "libmysql.dll" alias "mysql_list_processes" _
		( byval pMySql as long ) as long

declare function mysql_list_tables lib "libmysql.dll" alias "mysql_list_tables" _
		( byval pMySql as long, zWild as asciiz ) as long

declare function mysql_num_fields lib "libmysql.dll" alias "mysql_num_fields" _
		( rResult as MYSQL_RES ) as long

declare function mysql_num_rows lib "libmysql.dll" alias "mysql_num_rows" _
		( rResult as MYSQL_RES ) as long


declare function mysql_options lib "libmysql.dll" alias "mysql_options" _
      ( byval ptMYSQL as long, byval iOption as long, _
        szArg as any) as long

declare function mysql_ping lib "libmysql.dll" alias "mysql_ping"_
      ( byval pMYSQL  as long ) as long

declare function mysql_query lib "libmysql.dll" alias "mysql_query" _
		( byval pMySql as long, zQuery as asciiz ) as long

declare function mysql_real_connect lib "libmysql.dll" alias "mysql_real_connect" _
      ( byval pMySql as long, zHost as asciiz, zUserName as asciiz, _
        zPassword as asciiz, zDBName as asciiz, byval iPortNm as long, _
        zSocketName as asciiz, byval iFlags as long ) as long

declare function mysql_real_escape_string lib "libmysql.dll" alias "mysql_real_escape_string" _
		( byval pMySql as long, zTo as asciiz, zFrom as asciiz, _
		  byval iLen as long ) as long

declare function mysql_real_query lib "libmysql.dll" alias "mysql_real_query" _
		( byval pMySql as long, zQuery as asciiz, byval iLen as long ) as long

declare function mysql_reload lib "libmysql.dll" alias "mysql_reload" _
		( byval pMySql as long ) as long

declare function mysql_row_seek lib "libmysql.dll" alias "mysql_row_seek" _
		( rResult as MYSQL_RES, byval iOffset as long ) as long

declare function mysql_row_tell lib "libmysql.dll" alias "mysql_row_tell" _
		( rResult as MYSQL_RES ) as long

declare function mysql_select_db lib "libmysql.dll" alias "mysql_select_db" _
		( byval pMySql as long, zDB as asciiz ) as long

declare function mysql_shutdown lib "libmysql.dll" alias "mysql_shutdown" _
		( byval pMySql as long ) as long

declare function mysql_stat lib "libmysql.dll" alias "mysql_stat" _
		( byval pMySql as long ) as long

declare function mysql_store_result lib "libmysql.dll" alias "mysql_store_result" _
		( byval pMySql as long ) as long

declare function mysql_thread_id lib "libmysql.dll" alias "mysql_thread_id" _
		( byval pMySql as long ) as long

declare function mysql_use_result lib "libmysql.dll" alias "mysql_use_result" _
		( byval pMySql as long ) as long

declare function mysql_commit lib "libmysql.dll" alias "mysql_commit" _
		( byval pMySql as long ) as long

declare function mysql_rollback lib "libmysql.dll" alias "mysql_rollback" _
		( byval pMySql as long ) as long

declare function mysql_autocommit lib "libmysql.dll" alias "mysql_autocommit" _
		( byval pMySql as long, byval bMode as long ) as long

declare function mysql_more_results lib "libmysql.dll" alias "mysql_more_results" _
		( byval pMySql as long ) as long

declare function mysql_next_result lib "libmysql.dll" alias "mysql_next_result" _
		( byval pMySql as long ) as long
#endif
#endif
