'
'  pb_secur.bas
'
'  public domain code from Don Dickinson
'  don@greatwebdivide.com
'
#if not %def(%PB_SECUR_BAS)
%PB_SECUR_BAS = 1

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  Fills the tsa structure with a valid security attributes structure
'  Returns %true on success and %false on failure.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function getGlobalSecurity alias "getGlobalSecurity" _
      ( tsa as SECURITY_ATTRIBUTES, tsd as SECURITY_DESCRIPTOR, _
        pSidEveryone as Long, pACLNewDacl as ACL PTR ) as Long

   dim bOk as Long
   dim iSIDSize as Long
   dim iACLSize as Long
   dim tsiaWorld as SID_IDENTIFIER_AUTHORITY
   dim pSid as SID_IDENTIFIER_AUTHORITY PTR

   pSidEveryone = %null
   pACLNewDacl = %null

   if isNt() = %false then
      bOk = %false
      goto getGlobalSecurity_done
   end if

   'tsiaWorld.value(5) = 5     '%SECURITY_NT_AUTHORITY
   tsiaWorld.value(5) = 1     '%SECURITY_WORLD_SID_AUTHORITY

   '%SECURITY_LOCAL_SYSTEM_RID

   '- This function is supposed to return 0 on failure, but it
   '  appears to return 0 either way.
   '
   AllocateAndInitializeSid tsiaWorld, 1, %SECURITY_WORLD_RID, _
         0&, 0&, 0&, 0&, 0&, 0&, 0&, pSIDEveryone

   if pSIDEveryone = 0 then
      bOk = %false
      goto getGlobalSecurity_done
   end if

   iSidSize = GetLengthSid(pSIDEveryone)
   iACLSize= iSIDSize * 2 + len(ACCESS_ALLOWED_ACE) + len(ACCESS_DENIED_ACE) + len(ACL)
   pACLNewDacl = GetMem(iACLSize)
   if pACLNewDacl = %null then
      bOk = %false
      goto getGlobalSecurity_done
   end if

   if InitializeAcl(@pACLNewDacl, iACLSize, %ACL_REVISION) = %false then
      bOk = %false
      goto getGlobalSecurity_done
   end if

   if AddAccessAllowedAce ( @pACLNewDacl, %ACL_REVISION, _
         %GENERIC_READ or %GENERIC_WRITE or %GENERIC_ALL, _
         ByVal pSIDEveryone ) = %false then
      bOk = %false
      goto getGlobalSecurity_done
   end if

   if InitializeSecurityDescriptor ( tsd, %SECURITY_DESCRIPTOR_REVISION ) _
         = %false then
      bOk = %false
      goto getGlobalSecurity_done
   end if

   if SetSecurityDescriptorDacl ( tsd, %true, @pACLNewDacl, %false ) = %false then
      bOk = %false
      goto getGlobalSecurity_done
   end if

   tsa.nLength = sizeof(tsa)
   tsa.bInheritHandle = %false
   tsa.lpSecurityDescriptor = varptr(tsd)

   bOk = %true

getGlobalSecurity_done:

   if bOk = %false then
      if pSidEveryone then FreeSid pSidEveryone
      if pACLNewDacl then FreeMem pACLNewDacl
      pSidEveryone = %null
      pACLNewDacl = %null
   end if

   function = bOk

end function
#endif
