'
'	testmys.bas
'	test of Don Dickinson's mysql wrapper for powerbasic.
'	compile with pbcc 2.11 or greater
'
#compile exe
#dim all

'- this tells the mysql library that we're loading
'	the libmysql.dll file at runtime instead of making
'  our program dependent on it. It must be defined
'	before pb_mysql.bas
'
%PB_MYSQL_DYNAMIC_LOAD = 1

#include "testmys.inc"			'inclean'd winapi include
#include "pb_mysql.bas"			'mysql wrapper


$MYSQL_SERVER = "localhost"
$MYSQL_USER  = "admin"
$MYSQL_PASS = "password"
$MYSQL_DB = "testdb"

declare function deleteRecords(byval hMySQL as long) as long
declare function addRecords(byval hMySQL as long) as long
declare function updateRecords(byval hMySQL as long) as long
declare function loopRecords(byval hMySQL as long) as long
declare function showFirstRecord(byval hMySQL as long) as long
declare function createTable(byval hMySQL as long) as long

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	pbmain
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function pbmain()

	dim hMySQL as long

	'- this is necessary because we've defined %PB_MYSQL_DYNAMIC_LOAD
	if myInit() = %false then
		stdout "Unable to locate libmysql.dll"
		goto pbmain_done
	end if

	'- connect to the server
	hMySQL = myConnect($MYSQL_SERVER, "", $MYSQL_USER, $MYSQL_PASS, _
			%MYSQL_DEFAULT_PORT, 0)
	if hMySQL = 0 then
		stdout "ERROR"
		stdout "msg=" + myError(hMySQL)
		goto pbmain_done

	end if

	'- this is a little kludgy ... if the use fails, then
	'	i assume the db doesn't exist and try to create it.
	'
	if myUse(hMySQL, $MYSQL_DB) = %false then
		myCreateDB hMySQL, $MYSQL_DB
	end if

	'- If we still can't use it then something went terribly wrong.
	if myUse(hMySQL, $MYSQL_DB) = %false then
		stdout "Unable to create the needed database"
		goto pbmain_done
	end if

	'- Demonstrate the most popular data access requirements:
	'		1. creating a table
	'		2. inserting, updating, deleting records
	'		3.	executing an sql statement to return rows.
	'
	'if createTable(hMySQL) = %false then goto pbmain_done
	if addRecords(hMySQL) = %false then goto pbmain_done
	if loopRecords(hMySQL) = %false then goto pbmain_done
	if updateRecords(hMySQL) = %false then goto pbmain_done
	if loopRecords(hMySQL) = %false then goto pbmain_done
	if deleteRecords(hMySQL) = %false then goto pbmain_done
	if loopRecords(hMySQL) = %false then goto pbmain_done

pbmain_done:

	if hMySQL then myDisconnect hMySQL

	'- again necessary only because we've defined %PB_MYSQL_DYNAMIC_LOAD
	myFree

	waitkey$

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	createTable
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function createTable(byval hMySQL as long) as long

	dim sSQL as string

	stdout ""
	stdout "createTable"
	sSQL = "CREATE TABLE t_test (" + _
			"pers_id int unsigned auto_increment primary key," + _
			"pers_name varchar(50)," + _
			"pers_phone varchar(25) )"

	if myExecuteNoReturn(hMySQL, sSQL) = %false then
		stdout "Error creating table"
		stdout "myError=" + myError(hMySQL)
		function = %false
	else
		function = %true
	end if

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	addRecords
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function addRecords(byval hMySQL as long) as long

	dim sSQL as string

	stdout ""
	stdout "addRecords"

	sSQL = "INSERT INTO t_test " +_
			"(pers_name,pers_phone) " + _
			"VALUES ('Dickinson, Don','555-555-2345')"
	if myExecuteNoReturn(hMySQL, sSQL) = %false then
		stdout "ERROR executing SQL"
		stdout sSQL
		stdout myError(hMySQL)
		function = %false
		exit function
	end if

	sSQL = "INSERT INTO t_test " +_
			"(pers_name,pers_phone) " + _
			"VALUES ('Smith, Tom','555-555-3456')"
	if myExecuteNoReturn(hMySQL, sSQL) = %false then
		stdout "ERROR executing SQL"
		stdout sSQL
		stdout myError(hMySQL)
		function = %false
		exit function
	end if

	function = %true

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	loopRecords
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function loopRecords(byval hMySQL as long) as long

	dim pResultSet as long
	dim pFields as long
	dim sSQL as string

	stdout ""
	stdout "loopRecords"

	'- first execute the query. this returns a pointer to the
	'	result set (even if there are no rows) on success or 0 on failure.
	'
	sSQL = "SELECT * FROM t_test"
	pResultSet = myExecute(hMySQL, sSQL)
	if pResultSet = 0 then
		stdout "ERROR executing SQL"
		stdout myError(hMySQL)
		stdout "SQL=" + sSQL
		function = %false
		exit function
	end if

	'- now we loop through the results.
	do

		'- this returns %true on success or %false if we're out
		'	of data or there was an error.
		'
		pFields = myNextRow(hMySQL, pResultSet)
		if pFields = 0 then exit do

		'- utilize the results by calling myField*
		stdout trim$(myField(pFields, "pers_id")) + ": " + _
				myField(pFields, "pers_name") + " (" + _
				myField(pFields, "pers_phone") + ")"

		'- before going to the next record we need to
		'	free the memory for this record.
		'
		myFreeFields pFields
	loop

	'- when we're done with a result set, we must free it.
	myExecuteDone pResultSet

	function = %true

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	updateRecords
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function updateRecords(byval hMySQL as long) as long

	dim sSQL as string

	stdout ""
	stdout "updateRecords"
	sSQL = "UPDATE t_test SET pers_name='Dickinson, Donald' " + _
			"WHERE pers_name='Dickinson, Don'"
	if myExecuteNoReturn(hMySQL, sSQL) = 0 then
		stdout "ERROR executing SQL"
		stdout myError(hMySQL)
		stdout "SQL=" + sSQL
		function = %false
		exit function
	end if

	function = %true

end function

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	deleteRecords
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function deleteRecords(byval hMySQL as long) as long

	dim sSQL as string

	stdout ""
	stdout "deleteRecord"

	sSQL = "DELETE FROM t_test WHERE pers_name='Dickinson, Donald'"
	if myExecuteNoReturn(hMySQL, sSQL) = 0 then
		stdout "ERROR executing SQL"
		stdout myError(hMySQL)
		stdout "SQL=" + sSQL
		function = %false
		exit function
	end if

	function = %true

end function

