'
'  pb_sqlfr.inc
'
'  Translation of sqlfront.h that comes with Sql Server 7
'  by Don Dickinson
'  ddickinson@usinternet.com
'
#if not %def(%PB_SQLFR_INC)

%PB_SQLFR_INC = 1


'****************************************************************************
' DB-Library datatype definitions
'****************************************************************************
%DBMAXCHAR  = 256    '- Max length of DBVARBINARY and DBVARCHAR, etc.

%DBTYPEDEFS = 1   '- srv.h (Open Server include) not already included

%DBTYPEDEFS = 1

'- DB-Library datatypes
Type DBDATETIME4_TYPE
   numdays as Word
   nummins as Word
End Type

Type DBVARYCHAR_TYPE
   ln as Integer
   st as String * %DBMAXCHAR
End Type

Type DBVARYBIN_TYPE
   ln as Integer
   ar as String * %DBMAXCHAR
End Type

Type DBMONEY_TYPE
   mnyhigh as Long
   mnyLow as DWord
End Type

Type DBDATETIME_TYPE
   dtdays as Long
   dttime as DWord
End Type

Type DBDATEREC_TYPE
   yr as Integer
   qtr as Integer
   mn as Integer
   dayofyear as Integer
   dy as Integer
   wk as Integer
   wkday as Integer
   hr as Integer
   mnt as Integer
   sc as Integer
   ms as Integer
End Type

%MAXNUMERICLEN = 16
%MAXNUMERICDIG = 38

%DEFAULTPRECISION = 18
%DEFAULTSCALE     = 0

Type DBNUMERIC_TYPE
   precision as Byte
   scale as Byte
   sign as Byte
   vl as String * %MAXNUMERICLEN
End Type

%MAXCOLNAMELEN = 30
%MAXTABLENAME  = 30

Type DBCOL_TYPE WORD
   SizeOfStruct as Long
   zName as Asciiz * %MAXCOLNAMELEN + 1
   zActualName as Asciiz * %MAXCOLNAMELEN + 1
   zTableName as Asciiz * %MAXCOLNAMELEN + 1
   typ as Integer
   UserType as Long
   MaxLength as Long
   Precision as String * 1
   Scale as String * 1
   VarLength as Long
   Null as String * 1
   CaseSensitive as String * 1
   Updatable as String * 1
   Identity as Long
End Type

%MAXSERVERNAME    =  30
%MAXNETLIBNAME    = 255
%MAXNETLIBCONNSTR = 255

Type DBPROCINFO_TYPE WORD
   SizeOfStruct as Long
   ServerType as Byte
   ServerMajor as Word
   ServerMinor as Word
   ServerRevision as Word
   zServerName as Asciiz * %MAXSERVERNAME + 1
   zNetLibName as Asciiz * %MAXNETLIBNAME + 1
   zNetLibConnStr as Asciiz * %MAXNETLIBCONNSTR + 1
End Type

Type DBCURSORINFO_TYPE WORD
   SizeOfStruct as Long
   TotCols as DWord
   TotRows as DWord
   CurRow as DWord
   TotRowsFetched as DWord
   typ as DWord
   Status as DWord
End Type

%INVALID_UROWNUM = -1


'****************************************************************************
' General #defines
'****************************************************************************

%TIMEOUT_IGNORE = -1
%TIMEOUT_INFINITE = 0
%TIMEOUT_MAXIMUM = 1200 '- 20 minutes maximum timeout value

'- Used for ServerType in dbgetprocinfo
%SERVTYPE_UNKNOWN   = 0
%SERVTYPE_MICROSOFT = 1

'- Used by dbcolinfo
%CI_REGULAR = 1
%CI_ALTERNATE = 2
%CI_CURSOR = 3

'- Bulk Copy Definitions (bcp)
%DB_IN	= 1         '- Transfer from client to server
%DB_OUT	= 2         '- Transfer from server to client

%BCPMAXERRS   = 1    '- bcp_control parameter
%BCPFIRST     = 2    '- bcp_control parameter
%BCPLAST      = 3    '- bcp_control parameter
%BCPBATCH     = 4    '- bcp_control parameter
%BCPKEEPNULLS = 5    '- bcp_control parameter
%BCPABORT     = 6    '- bcp_control parameter

%TINYBIND         = 1
%SMALLBIND        = 2
%INTBIND          = 3
%CHARBIND         = 4
%BINARYBIND       = 5
%BITBIND          = 6
%DATETIMEBIND     = 7
%MONEYBIND        = 8
%FLT8BIND         = 9
%STRINGBIND      = 10
%NTBSTRINGBIND   = 11
%VARYCHARBIND    = 12
%VARYBINBIND     = 13
%FLT4BIND        = 14
%SMALLMONEYBIND  = 15
%SMALLDATETIBIND = 16
%DECIMALBIND     = 17
%NUMERICBIND     = 18
%SRCDECIMALBIND  = 19
%SRCNUMERICBIND  = 20
%MAXBIND         = %SRCNUMERICBIND

%DBSAVE          = 1
%DBNOSAVE        = 0

%DBNOERR         = -1
%DBFINDONE       = &h04  '- Definately done
%DBMORE          = &h10  '- Maybe more commands waiting
%DBMORE_ROWS     = &h20  '- This command returned rows

%MAXNAME         = 31


%DBTXTSLEN       = 8     '- Timestamp length

%DBTXPLEN        = 16    '- Text pointer length

'- Error code returns
%INT_EXIT        = 0
%INT_CONTINUE    = 1
%INT_CANCEL      = 2


'- dboptions
%DBBUFFER        = 0
%DBOFFSET        = 1
%DBROWCOUNT      = 2
%DBSTAT          = 3
%DBTEXTLIMIT     = 4
%DBTEXTSIZE      = 5
%DBARITHABORT    = 6
%DBARITHIGNORE   = 7
%DBNOAUTOFREE    = 8
%DBNOCOUNT       = 9
%DBNOEXEC        = 10
%DBPARSEONLY     = 11
%DBSHOWPLAN      = 12
%DBSTORPROCID	  = 13
%DBANSItoOEM		= 14
%DBOEMtoANSI		= 15
%DBCLIENTCURSORS = 16
%DBSETTIME = 17
%DBQUOTEDIDENT = 18


'- Data Type Tokens
%SQLVOID        = &h1f
%SQLTEXT        = &h23
%SQLVARBINARY   = &h25
%SQLINTN        = &h26
%SQLVARCHAR     = &h27
%SQLBINARY      = &h2d
%SQLIMAGE       = &h22
%SQLCHAR        = &h2f
%SQLINT1        = &h30
%SQLBIT         = &h32
%SQLINT2        = &h34
%SQLINT4        = &h38
%SQLMONEY       = &h3c
%SQLDATETIME    = &h3d
%SQLFLT8        = &h3e
%SQLFLTN        = &h6d
%SQLMONEYN      = &h6e
%SQLDATETIMN    = &h6f
%SQLFLT4        = &h3b
%SQLMONEY4      = &h7a
%SQLDATETIM4    = &h3a
%SQLDECIMAL     = &h6a
%SQLNUMERIC     = &h6c

'- Data stream tokens
%SQLCOLFMT      = &ha1
%OLD_SQLCOLFMT  = &h2a
%SQLPROCID      = &h7c
%SQLCOLNAME     = &ha0
%SQLTABNAME     = &ha4
%SQLCOLINFO     = &ha5
%SQLALTNAME     = &ha7
%SQLALTFMT      = &ha8
%SQLERROR       = &haa
%SQLINFO        = &hab
%SQLRETURNVALUE = &hac
%SQLRETURNSTATUS = &h79
%SQLRETURN      = &hdb
%SQLCONTROL     = &hae
%SQLALTCONTROL  = &haf
%SQLROW         = &hd1
%SQLALTROW      = &hd3
%SQLDONE        = &hfd
%SQLDONEPROC    = &hfe
%SQLDONEINPROC  = &hff
%SQLOFFSET      = &h78
%SQLORDER       = &ha9
%SQLLOGINACK    = &had '- NOTICE: change to real value

'- Ag op tokens
%SQLAOPCNT		= &h4b
%SQLAOPSUM    = &h4d
%SQLAOPAVG    = &h4f
%SQLAOPMIN    = &h51
%SQLAOPMAX    = &h52
%SQLAOPANY    = &h53
%SQLAOPNOOP   = &h56

'- Error numbers (dberrs) DB-Library error codes
%SQLEMEM         = 10000
%SQLENULL        = 10001
%SQLENLOG        = 10002
%SQLEPWD         = 10003
%SQLECONN        = 10004
%SQLEDDNE        = 10005
%SQLENULLO       = 10006
%SQLESMSG        = 10007
%SQLEBTOK        = 10008
%SQLENSPE        = 10009
%SQLEREAD        = 10010
%SQLECNOR        = 10011
%SQLETSIT        = 10012
%SQLEPARM        = 10013
%SQLEAUTN        = 10014
%SQLECOFL        = 10015
%SQLERDCN        = 10016
%SQLEICN         = 10017
%SQLECLOS        = 10018
%SQLENTXT        = 10019
%SQLEDNTI        = 10020
%SQLETMTD        = 10021
%SQLEASEC        = 10022
%SQLENTLL        = 10023
%SQLETIME        = 10024
%SQLEWRIT        = 10025
%SQLEMODE        = 10026
%SQLEOOB         = 10027
%SQLEITIM        = 10028
%SQLEDBPS        = 10029
%SQLEIOPT        = 10030
%SQLEASNL        = 10031
%SQLEASUL        = 10032
%SQLENPRM        = 10033
%SQLEDBOP        = 10034
%SQLENSIP        = 10035
%SQLECNULL       = 10036
%SQLESEOF        = 10037
%SQLERPND        = 10038
%SQLECSYN        = 10039
%SQLENONET       = 10040
%SQLEBTYP        = 10041
%SQLEABNC        = 10042
%SQLEABMT        = 10043
%SQLEABNP        = 10044
%SQLEBNCR        = 10045
%SQLEAAMT        = 10046
%SQLENXID        = 10047
%SQLEIFNB        = 10048
%SQLEKBCO        = 10049
%SQLEBBCI        = 10050
%SQLEKBCI        = 10051
%SQLEBCWE        = 10052
%SQLEBCNN        = 10053
%SQLEBCOR        = 10054
%SQLEBCPI        = 10055
%SQLEBCPN        = 10056
%SQLEBCPB        = 10057
%SQLEVDPT        = 10058
%SQLEBIVI        = 10059
%SQLEBCBC        = 10060
%SQLEBCFO        = 10061
%SQLEBCVH        = 10062
%SQLEBCUO        = 0063
%SQLEBUOE        = 10064
%SQLEBWEF        = 10065
%SQLEBTMT        = 10066
%SQLEBEOF        = 10067
%SQLEBCSI        = 10068
%SQLEPNUL        = 10069
%SQLEBSKERR      = 10070
%SQLEBDIO        = 10071
%SQLEBCNT        = 10072
%SQLEMDBP        = 10073
%SQLINIT         = 10074
%SQLCRSINV       = 10075
%SQLCRSCMD       = 10076
%SQLCRSNOIND     = 10077
%SQLCRSDIS       = 10078
%SQLCRSAGR       = 10079
%SQLCRSORD       = 10080
%SQLCRSMEM       = 10081
%SQLCRSBSKEY     = 10082
%SQLCRSNORES     = 10083
%SQLCRSVIEW      = 10084
%SQLCRSBUFR      = 10085
%SQLCRSFROWN     = 10086
%SQLCRSBROL      = 10087
%SQLCRSFRAND     = 10088
%SQLCRSFLAST     = 10089
%SQLCRSRO        = 10090
%SQLCRSTAB       = 10091
%SQLCRSUPDTAB    = 10092
%SQLCRSUPDNB     = 10093
%SQLCRSVIIND     = 10094
%SQLCRSNOUPD     = 10095
%SQLCRSOS2       = 10096
%SQLEBCSA        = 10097
%SQLEBCRO        = 10098
%SQLEBCNE        = 10099
%SQLEBCSK        = 10100
%SQLEUVBF        = 10101
%SQLEBIHC        = 10102
%SQLEBWFF        = 10103
%SQLNUMVAL       = 10104
%SQLEOLDVR       = 10105
%SQLEBCPS	     = 10106
%SQLEDTC 	     = 10107
%SQLENOTIMPL	  = 10108
%SQLENONFLOAT	  = 10109
%SQLECONNFB      = 10110


'- The severity levels are defined here
%EXINFO          = 1  '- Informational, non-error
%EXUSER          = 2  '- User error
%EXNONFATAL      = 3  '- Non-fatal error
%EXCONVERSION    = 4  '- Error in DB-LIBRARY data conversion
%EXSERVER        = 5  '- The Server has returned an error flag
%EXTIME          = 6  '- We have exceeded our timeout period while
                           '- waiting for a response from the Server - the
                           '- DBPROCESS is still alive
%EXPROGRAM       = 7  '- Coding error in user program
%EXRESOURCE      = 8  '- Running out of resources - the DBPROCESS may be dead
%EXCOMM          = 9  '- Failure in communication with Server - the DBPROCESS is dead
%EXFATAL         = 10 '- Fatal error - the DBPROCESS is dead
%EXCONSISTENCY   = 11 '- Internal software error  - notify MS Technical Supprt

'- Offset identifiers
%OFF_SELECT      = &h16d
%OFF_FROM        = &h14f
%OFF_ORDER       = &h165
%OFF_COMPUTE     = &h139
%OFF_TABLE       = &h173
%OFF_PROCEDURE   = &h16a
%OFF_STATEMENT   = &h1cb
%OFF_PARAM       = &h1c4
%OFF_EXEC        = &h12c

'- Print lengths for certain fixed length data types
%PRINT4     = 11
%PRINT2     = 6
%PRINT1     = 3
%PRFLT8     = 20
%PRMONEY    = 26
%PRBIT      = 3
%PRDATETIME = 27
%PRDECIMAL = (%MAXNUMERICDIG + 2)
%PRNUMERIC = (%MAXNUMERICDIG + 2)

%SUCCEED  = 1
%FAIL     = 0
%SUCCEED_ABORT = 2

%DBUNKNOWN = 2

%MORE_ROWS    = -1
%NO_MORE_ROWS = -2
%REG_ROW      = %MORE_ROWS
%BUF_FULL     = -3

'- Status code for dbresults(). Possible return values are
'- SUCCEED, FAIL, and NO_MORE_RESULTS.
%NO_MORE_RESULTS = 2
%NO_MORE_RPC_RESULTS = 3

'- Macros for dbsetlname()
%DBSETHOST = 1
%DBSETUSER = 2
%DBSETPWD  = 3
%DBSETAPP  = 4
%DBSETID   = 5
%DBSETLANG = 6
%DBSETSECURE = 7
%DBVER42    = 8
%DBVER60    = 9
%DBSETLOGINTIME = 10
%DBSETFALLBACK = 12

'- Standard exit and error values
%STDEXIT  = 0
%ERREXIT  = -1

'- dbrpcinit flags
%DBRPCRECOMPILE  = &h0001
%DBRPCRESET      = &h0004
%DBRPCCURSOR     = &h0008

'- dbrpcparam flags
%DBRPCRETURN     = &h1
%DBRPCDEFAULT    = &h2


'- Cursor related constants

'- Following flags are used in the concuropt parameter in the dbcursoropen function
%CUR_READONLY = 1 '- Read only cursor, no data modifications
%CUR_LOCKCC   = 2 '- Intent to update, all fetched data locked when
                       '- dbcursorfetch is called inside a transaction block
%CUR_OPTCC    = 3 '- Optimistic concurrency control, data modifications
                       '- succeed only if the row hasn't been updated since
                       '- the last fetch.
%CUR_OPTCCVAL = 4 '- Optimistic concurrency control based on selected column values

'- Following flags are used in the scrollopt parameter in dbcursoropen
%CUR_FORWARD = 0       '- Forward only scrolling
%CUR_KEYSET  = -1      '- Keyset driven scrolling
%CUR_DYNAMIC = 1       '- Fully dynamic
%CUR_INSENSITIVE = -2  '- Server-side cursors only

'- Following flags define the fetchtype in the dbcursorfetch function
%FETCH_FIRST    = 1  '- Fetch first n rows
%FETCH_NEXT     = 2  '- Fetch next n rows
%FETCH_PREV     = 3  '- Fetch previous n rows
%FETCH_RANDOM   = 4  '- Fetch n rows beginning with given row #
%FETCH_RELATIVE = 5  '- Fetch relative to previous fetch row #
%FETCH_LAST     = 6  '- Fetch the last n rows

'- Following flags define the per row status as filled by dbcursorfetch and/or dbcursorfetchex
%FTC_EMPTY         = &h00  '- No row available
%FTC_SUCCEED       = &h01  '- Fetch succeeded, (failed if not set)
%FTC_MISSING       = &h02  '- The row is missing
%FTC_ENDOFKEYSET   = &h04  '- End of the keyset reached
%FTC_ENDOFRESULTS  = &h08  '- End of results set reached

'- Following flags define the operator types for the dbcursor function
%CRS_UPDATE   = 1  '- Update operation
%CRS_DELETE   = 2  '- Delete operation
%CRS_INSERT   = 3  '- Insert operation
%CRS_REFRESH  = 4  '- Refetch given row
%CRS_LOCKCC   = 5  '- Lock given row

'- Following value can be passed to the dbcursorbind function for NOBIND type
%NOBIND = -2       '- Return length and pointer to data

'- Following are values used by DBCURSORINFO's Type parameter
%CU_CLIENT        = &h00000001
%CU_SERVER        = &h00000002
%CU_KEYSET        = &h00000004
%CU_MIXED         = &h00000008
%CU_DYNAMIC       = &h00000010
%CU_FORWARD       = &h00000020
%CU_INSENSITIVE   = &h00000040
%CU_READONLY      = &h00000080
%CU_LOCKCC        = &h00000100
%CU_OPTCC         = &h00000200
%CU_OPTCCVAL      = &h00000400

'- Following are values used by DBCURSORINFO's Status parameter
%CU_FILLING       = &h00000001
%CU_FILLED        = &h00000002


'- Following are values used by dbupdatetext's type parameter
%UT_TEXTPTR      = &h0001
%UT_TEXT         = &h0002
%UT_MORETEXT     = &h0004
%UT_DELETEONLY   = &h0008
%UT_LOG          = &h0010


'- The following values are passed to dbserverenum for searching criteria.
%NET_SEARCH  = &h0001
%LOC_SEARCH  = &h0002

'- These constants are the possible return values from dbserverenum.
%ENUM_SUCCESS         = &h0000
%MORE_DATA            = &h0001
%NET_NOT_AVAIL        = &h0002
%OUT_OF_MEMORY        = &h0004
%NOT_SUPPORTED        = &h0008
%ENUM_INVALID_PARAM   = &h0010


'- Netlib Error problem codes.  ConnectionError() should return one of
'- these as the dblib-mapped problem code, so the corresponding string
'- is sent to the dblib app's error handler as dberrstr.  Return NE_E_NOMAP
'- for a generic DB-Library error string (as in prior versions of dblib).

%NE_E_NOMAP              = 0   '- No string; uses dblib default.
%NE_E_NOMEMORY           = 1   '- Insufficient memory.
%NE_E_NOACCESS           = 2   '- Access denied.
%NE_E_CONNBUSY           = 3   '- Connection is busy.
%NE_E_CONNBROKEN         = 4   '- Connection broken.
%NE_E_TOOMANYCONN        = 5   '- Connection limit exceeded.
%NE_E_SERVERNOTFOUND     = 6   '- Specified SQL server not found.
%NE_E_NETNOTSTARTED      = 7   '- The network has not been started.
%NE_E_NORESOURCE         = 8   '- Insufficient network resources.
%NE_E_NETBUSY            = 9   '- Network is busy.
%NE_E_NONETACCESS        = 10  '- Network access denied.
%NE_E_GENERAL            = 11  '- General network error.  Check your documentation.
%NE_E_CONNMODE           = 12  '- Incorrect connection mode.
%NE_E_NAMENOTFOUND       = 13  '- Name not found in directory service.
%NE_E_INVALIDCONN        = 14  '- Invalid connection.
%NE_E_NETDATAERR         = 15  '- Error reading or writing network data.
%NE_E_TOOMANYFILES       = 16  '- Too many open file handles.
%NE_E_CANTCONNECT		    = 17  '- SQL Server does not exist or access denied.

%NE_MAX_NETERROR         = 17

#endif
