'
'  pb_srv.bas
'
'  DESCRIPTION
'     Translation of Microsoft's srv.h Open Data Services header file: srv.h
'     to powerbasic.
'
'  TRANSLATION
'     By Don Dickinson
'     ddickinson@usinternet.com
'     http://dickinson.basicguru.com
'
'  COPYRIGHT
'     Open Data Services header file: srv.h
'     Copyright (c) 1989, 1990, 1991, 1997 by Microsoft Corp.
'
'  NOTE
'     >> All structures should be dword aligned (4 byte structure alignment)
'     >> Functions are exported from opends60.dll
'
#if not %def(%PB_SRV_BAS)

%PB_SRV_BAS = 1

#include "win32api.inc"       'winapi declares from PowerBasic
#include "pb_sqlfr.inc"       'constants and structures from dblib declares


Type SRV_PROC
   ptr as Dword
End Type

#if 0
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  the all-important SRV_PROC structure
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Type SRV_PROC align dword
   tdsVersion as Word
   dwStatus as Word
   srvIO as SRV_IO
   srvLoginRec as SRV_LOGINREC
   langBuf as Dword
   longLen as Dword
   ievent as Dword
   pServer as Dword
   pThreadStack as Dword
   threadID as Long
   threadHDL as Long
   ioWakeup as Long
   exited as Long
   rowSent as Long
   pColDesc as Dword
   colDescNo as Integer
   pColName as Dword
   colNameLen as Word
   pUserData as Dword
   pEventData as Dword
   serverlen as Byte
   pServerName as Dword
   rpc_active as Byte
   rpc_server_len as Byte
   p_rpc_server as Dword
   rpc_database_len as Byte
   p_rpc_database as Dword
   rpc_owner_len as Byte
   p_rpc_owner as Dword
   rpc_proc_len as Byte
   p_rpc_proc_name as Dword
   rpc_proc_number as DWord
   rpc_linenumber as DWord
   rpc_options as Word
   rpc_num_params as Word
   pp_rpc_params as Dword
   non_rpc_active as Byte
   non_rpc_num_params as Word
   pp_non_rpc_params as Dword
   temp_buffer as String * 100
   pp_subprocs as Dword
   translationInfo as TRANSLATION_INFO
   ioListEntry as SRV_LISTENTRY
   commandListEntry as SRV_LIST_ENTRY
   pNetListHead as Dword
   bNewPacket as Long
   Statuscrit as Long
   pServerData as Dword
   pSubChannel as Dword
   p_pre_events as DWord
   p_post_events as Dword
   p_langbuffer as Dword
   fSecureLogin as Long
   fInExtendedProc as Long
   fLocalPost as Long
   fMadeBoundCall as Long
   uFill1 as Long
   comport_queue as SRV_COMPORT_QUEUE
   pSF1 as Dword
   pSF2 as Dword
   hPreHandlerMutex as Long
   hPostHandlerMutex as Long
   bSAxp as Long
End Type
#endif

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  Constants used by APIs
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'- Type Tokens
%SRV_TDS_NULL           = &h1f
%SRV_TDS_TEXT           = &h23
%SRV_TDS_GUID           = &h24
%SRV_TDS_VARBINARY      = &h25
%SRV_TDS_INTN           = &h26
%SRV_TDS_VARCHAR        = &h27
%SRV_TDS_BINARY         = &h2d
%SRV_TDS_IMAGE          = &h22
%SRV_TDS_CHAR           = &h2f
%SRV_TDS_INT1           = &h30
%SRV_TDS_BIT            = &h32
%SRV_TDS_INT2           = &h34
%SRV_TDS_DECIMAL        = &h37
%SRV_TDS_INT4           = &h38
%SRV_TDS_DATETIM4       = &h3a
%SRV_TDS_FLT4           = &h3b
%SRV_TDS_MONEY          = &h3c
%SRV_TDS_DATETIME       = &h3d
%SRV_TDS_FLT8           = &h3e
%SRV_TDS_NUMERIC        = &h3f
%SRV_TDS_NTEXT		      = &h63
%SRV_TDS_BITN		      = &h68
%SRV_TDS_DECIMALN       = &h6a
%SRV_TDS_NUMERICN       = &h6c
%SRV_TDS_FLTN           = &h6d
%SRV_TDS_MONEYN         = &h6e
%SRV_TDS_DATETIMN       = &h6f
%SRV_TDS_MONEY4         = &h7a
%SRV_TDS_BIGVARBINARY   = &hA5
%SRV_TDS_BIGVARCHAR     = &hA7
%SRV_TDS_BIGBINARY      = &hAD
%SRV_TDS_BIGCHAR        = &hAF
%SRV_TDS_NVARCHAR	      = &he7
%SRV_TDS_NCHAR		      = &hef

'- Datatypes
'- Also: values of symbol parameter to srv_symbol when type = SRV_DATATYPE
%SRVNULL          = %SRV_TDS_NULL
%SRVTEXT          = %SRV_TDS_TEXT
%SRVGUID          = %SRV_TDS_GUID
%SRVVARBINARY     = %SRV_TDS_VARBINARY
%SRVINTN          = %SRV_TDS_INTN
%SRVVARCHAR       = %SRV_TDS_VARCHAR
%SRVBINARY        = %SRV_TDS_BINARY
%SRVIMAGE         = %SRV_TDS_IMAGE
%SRVCHAR          = %SRV_TDS_CHAR
%SRVINT1          = %SRV_TDS_INT1
%SRVBIT           = %SRV_TDS_BIT
%SRVINT2          = %SRV_TDS_INT2
%SRVDECIMAL	      = %SRV_TDS_DECIMAL
%SRVINT4          = %SRV_TDS_INT4
%SRVDATETIM4      = %SRV_TDS_DATETIM4
%SRVFLT4          = %SRV_TDS_FLT4
%SRVMONEY         = %SRV_TDS_MONEY
%SRVDATETIME      = %SRV_TDS_DATETIME
%SRVFLT8          = %SRV_TDS_FLT8
%SRVNUMERIC	      = %SRV_TDS_NUMERIC
%SRVNTEXT	      = %SRV_TDS_NTEXT
%SRVBITN		      = %SRV_TDS_BITN
%SRVDECIMALN	   = %SRV_TDS_DECIMALN
%SRVNUMERICN	   = %SRV_TDS_NUMERICN
%SRVFLTN          = %SRV_TDS_FLTN
%SRVMONEYN        = %SRV_TDS_MONEYN
%SRVDATETIMN      = %SRV_TDS_DATETIMN
%SRVMONEY4        = %SRV_TDS_MONEY4
%SRVBIGVARBINARY  = %SRV_TDS_BIGVARBINARY
%SRVBIGVARCHAR    = %SRV_TDS_BIGVARCHAR
%SRVBIGBINARY     = %SRV_TDS_BIGBINARY
%SRVBIGCHAR       = %SRV_TDS_BIGCHAR
%SRVNVARCHAR	   = %SRV_TDS_NVARCHAR
%SRVNCHAR	      = %SRV_TDS_NCHAR

'- values for srv_symbol type parameter
%SRV_ERROR      = 0
%SRV_DONE       = 1
%SRV_DATATYPE   = 2
%SRV_EVENT      = 4

'- values for srv_symbol symbol parameter, when type = SRV_ERROR
%SRV_ENO_OS_ERR     = 0
%SRV_INFO           = 1
%SRV_FATAL_PROCESS  = 10
%SRV_FATAL_SERVER   = 19

'- Types of server events
'- Also: values for srv_symbol symbol parameter, when type = SRV_EVENT
%SRV_CONTINUE       = 0
%SRV_LANGUAGE       = 1
%SRV_CONNECT        = 2
%SRV_RPC            = 3
%SRV_RESTART        = 4
%SRV_DISCONNECT     = 5
%SRV_ATTENTION      = 6
%SRV_SLEEP          = 7
%SRV_START          = 8
%SRV_STOP           = 9
%SRV_EXIT           = 10
%SRV_CANCEL         = 11
%SRV_SETUP          = 12
%SRV_CLOSE          = 13
%SRV_PRACK          = 14
%SRV_PRERROR        = 15
%SRV_ATTENTION_ACK  = 16
%SRV_CONNECT_V7	   = 16	'- TDS type for TDS 7 clients.  Overloaded with SRV_ATTENTION_ACK
%SRV_SKIP		   = 17
%SRV_TRANSMGR	   = 18
%SRV_OLEDB	       = 20
%SRV_INTERNAL_HANDLER = 99
%SRV_PROGRAMMER_DEFINED  = 100

'- values for srv_config option parameter
%SRV_CONNECTIONS         = 1
%SRV_LOGFILE             = 2
%SRV_STACKSIZE           = 3
%SRV_REMOTE_ACCESS       = 7
%SRV_REMOTE_CONNECTIONS  = 9
%SRV_MAX_PACKETS         = 10
%SRV_MAXWORKINGTHREADS	= 11
%SRV_MINWORKINGTHREADS	= 12
%SRV_THREADTIMEOUT		= 13
%SRV_MAX_PACKETSIZE		= 17
%SRV_THREADPRIORITY		= 18
%SRV_ANSI_CODEPAGE		= 19
%SRV_DEFAULT_PACKETSIZE	= 26
%SRV_PASSTHROUGH			= 27

'- vlaues for srv_config value parameter when option = SRV_THREADPRIORITY
%SRV_PRIORITY_LOW      = %THREAD_PRIORITY_LOWEST
%SRV_PRIORITY_NORMAL   = %THREAD_PRIORITY_NORMAL
%SRV_PRIORITY_HIGH     = %THREAD_PRIORITY_HIGHEST
%SRV_PRIORITY_CRITICAL = %THREAD_PRIORITY_TIME_CRITICAL

'- values for srv_sfield field parameter
%SRV_SERVERNAME          = 0
%SRV_VERSION             = 6

'- Length to indicate string is null terminated
%SRV_NULLTERM   = -1

'- values of msgtype parameter to srv_sendmsg
%SRV_MSG_INFO    = 1
%SRV_MSG_ERROR   = 2

'- values of status parameter to srv_senddone
'- Also: values for symbol parameters to srv_symbol when type = SRV_DONE
%SRV_DONE_FINAL	= &h0000
%SRV_DONE_MORE		= &h0001
%SRV_DONE_ERROR	= &h0002
%SRV_DONE_COUNT	= &h0010
%SRV_DONE_RPC_IN_BATCH = &h0080

'- return values of srv_paramstatus
%SRV_PARAMRETURN		= &h0001
%SRV_PARAMDEFAULT    = &h0002

'- return values of srv_rpcoptions
%SRV_RECOMPILE		= &h0001
%SRV_NOMETADATA		= &h0002

'- values of field parameter to srv_pfield
'%SRV_LANGUAGE 1   already defined above
'%SRV_EVENT    4   already defined above
%SRV_SPID				= 10
%SRV_NETSPID			= 11
%SRV_TYPE				= 12
%SRV_STATUS				= 13
%SRV_RMTSERVER			= 14
%SRV_HOST				= 15
%SRV_USER				= 16
%SRV_PWD					= 17
%SRV_CPID				= 18
%SRV_APPLNAME			= 19
%SRV_TDS					= 20
%SRV_CLIB				= 21
%SRV_LIBVERS				= 22
%SRV_ROWSENT				= 23
%SRV_BCPFLAG				= 24
%SRV_NATLANG				= 25
%SRV_PIPEHANDLE			= 26
%SRV_NETWORK_MODULE	    = 27
%SRV_NETWORK_VERSION		= 28
%SRV_NETWORK_CONNECTION	= 29
%SRV_LSECURE				= 30
%SRV_SAXP				= 31
%SRV_UNICODE_USER		= 33
%SRV_UNICODE_PWD			= 35
%SRV_SPROC_CODEPAGE       = 36

'- return value of SRV_TDSVERSION macro
%SRV_TDS_NONE   = 0
%SRV_TDS_2_0    = 1
%SRV_TDS_3_4    = 2
%SRV_TDS_4_2    = 3
%SRV_TDS_6_0    = 4
%SRV_TDS_7_0    = 5

'- additional return value for srv_pre/post_handle
%SRV_DUPLICATE_HANDLER	= 2

'- ODS MACROs & APIs

'- Describing and sending a result set
declare function srv_describe cdecl lib "opends60.dll" alias "srv_describe" _
      ( srvProc as SRV_PROC, ByVal iColNumber as Long, zColumnName as Asciiz, _
        ByVal iNameLen as Long, ByVal iDestType as Long, ByVal iDestLen as Long, _
        ByVal iSrcType as Long, ByVal iSrcLen as Long, srcData as Any ) as Long

declare function srv_setutype cdecl lib "opends60.dll" alias "srv_setutype" _
      ( srvProc as SRV_PROC, ByVal iCol as Long, ByVal iUType as Long ) as Long

declare function srv_setcoldata cdecl lib "opends60.dll" alias "srv_setcoldata" _
      ( srvProc as SRV_PROC, ByVal iColumn as Long, pData as Any ) as Long

declare function srv_setcollen cdecl lib "opends60.dll" alias "srv_setcollen" _
      ( srvProc as SRV_PROC, ByVal iCol as Long, ByVal iLen as Long ) as Long

declare function srv_sendrow cdecl lib "opends60.dll" alias "srv_sendrow" _
      ( srvProc as SRV_PROC ) as Long

declare function srv_senddone cdecl lib "opends60.dll" alias "srv_senddone" _
      ( srvProc as SRV_PROC, ByVal wStatus as Word, ByVal wCurCmd as Word, _
        ByVal iCount as Long ) as Long

'- Dealing with Extended Procedure parameters
declare function srv_rpcparams cdecl lib "opends60.dll" alias "srv_rpcparams" _
      ( srvProc as SRV_PROC ) as Long

declare function srv_paraminfo cdecl lib "opends60.dll" alias "srv_paraminfo" _
      ( srvProc as SRV_PROC, ByVal n as Long, bType as Byte, _
        dwMaxLen as Dword, dwActualLen as Dword, pData as Any, _
        iNull as Long ) as Long

declare function srv_paramsetoutput cdecl lib "opends60.dll" alias "srv_paramsetoutput" _
      ( srvProc as SRV_PROC, ByVal n as Long, pData as Any, ByVal dwLen as Dword, _
        ByVal iNull as Long ) as Long

declare function srv_paramdata cdecl lib "opends60.dll" alias "srv_paramdata" _
      ( srvProc as SRV_PROC, ByVal n as Long ) as Dword

declare function srv_paramlen cdecl lib "opends60.dll" alias "srv_paramlen" _
      ( srvProc as SRV_PROC, ByVal n as Long ) as Long

declare function srv_parammaxlen cdecl lib "opends60.dll" alias "srv_parammaxlen" _
      ( srvProc as SRV_PROC, ByVal n as Long ) as Long

declare function srv_paramtype cdecl lib "opends60.dll" alias "srv_paramtype" _
      ( srvProc as SRV_PROC, ByVal n as Long ) as Long

declare function srv_paramset cdecl lib "opends60.dll" alias "srv_paramset" _
      ( srvProc as SRV_PROC, ByVal n as Long, pData as Any, ByVal iLen as Long ) as Long

declare function srv_paramname cdecl lib "opends60.dll" alias "srv_paramname" _
      ( srvProc as SRV_PROC, ByVal iParam as Long, iLen as Long ) as Dword

declare function srv_paramnumber cdecl lib "opends60.dll" alias "srv_paramnumber" _
      ( srvProc as SRV_PROC, zName as Asciiz, ByVal iNameLen as Long ) as Long

declare function srv_sendmsg cdecl lib "opends60.dll" alias "srv_sendmsg" _
      ( srvProc as SRV_PROC, ByVal iMsgType as Long, ByVal msgNum as Long, _
        ByVal msgClass as Byte, ByVal byState as Byte, zRPCName as Asciiz, _
        ByVal rpcNameLen as Long, ByVal lineNum as Word, zMsg as Asciiz, _
        ByVal iMsgLen as Long ) as Long

declare function srv_paramstatus cdecl lib "opends60.dll" alias "srv_paramstatus" _
      ( srvProc as SRV_PROC, ByVal n as Long ) as Long

#if 0
'- The rest of these APIs are still supported, in SQL Server 7.0,
'- but may not be supported after SQL Server 7.0

'- MACROs
'%SRV_GETCONFIG(a)		srv_getconfig	  ( a )
'%SRV_GETSERVER(a)		srv_getserver	  ( a )
'%SRV_GOT_ATTENTION(a)	srv_got_attention ( a )
'#define	SRV_EVENTDATA(a)		srv_eventdata	  ( a )
'#define	SRV_IODEAD(a)			srv_iodead		  ( a )
'#define	SRV_TDSVERSION(a)		srv_tdsversion	  ( a )

SRV_CONFIG* srv_getconfig( SRV_SERVER * server );
SRV_SERVER* srv_getserver( SRV_PROC   * srvproc );
BOOL srv_got_attention( SRV_PROC * srvproc );
void* srv_eventdata( SRV_PROC * srvproc );

'- Memory
void* srv_alloc(long int ulSize);
int srv_bmove(void* from,void* to,long int count);
int srv_bzero( void  * location,long int count);
int srv_free( void * ptr );

int srv_config( SRV_CONFIG * config,long int option,char* value,int valuelen);
SRV_CONFIG * srv_config_alloc( void );


int srv_convert(SRV_PROC*,int,void*,long int,int,void*,long int);

int (*  srv_errhandle(int (* handler)(SRV_SERVER * server,
												  SRV_PROC   * srvproc,
												  int		   srverror,
												  BYTE 	       severity,
												  BYTE 	       state,
												  int		   oserrnum,
												  char     * errtext,
												  int		   errtextlen,
												  char     * oserrtext,
												  int		   oserrtextlen)))
												   ( SRV_SERVER * server,
													 SRV_PROC   * srvproc,
													 int		  srverror,
													 BYTE 	      severity,
													 BYTE 	      state,
													 int		  oserrnum,
													 char     * errtext,
													 int		  errtextlen,
													 char     * oserrtext,
													 int		  oserrtextlen );

int srv_event(SRV_PROC * srvproc,int event,BYTE* data);

void* srv_getuserdata( SRV_PROC * srvproc );

int srv_getbindtoken(SRV_PROC * srvproc,char* token_buf);

int srv_getdtcxact(SRV_PROC * srvproc,void ** ppv);

typedef int (* EventHandler)(void*);
EventHandler srv_handle(SRV_SERVER*,long int,EventHandler);

int srv_impersonate_client( SRV_PROC * srvproc );

SRV_SERVER* srv_init( SRV_CONFIG * config,
					 char	    * connectname,
					 int	      namelen );

BOOL srv_iodead( SRV_PROC * srvproc );

long srv_langcpy(SRV_PROC *	srvproc,long start,long nbytes,char* buffer);
long srv_langlen( SRV_PROC * srvproc );
void* srv_langptr( SRV_PROC *srvproc );

int
     srv_log( SRV_SERVER * server,
					BOOL	     datestamp,
					char     * msg,
					int 	     msglen );

int srv_paramstatus(SRV_PROC*,int);

char* srv_pfield( SRV_PROC * srvproc,int	      field,int	    * len );

int srv_returnval( SRV_PROC * srvproc,
						  char   * valuename,
						  int		 len,
						  BYTE		 status,
						  long int 	 type,
						  long int 	 maxlen,
						  long int 	 datalen,
						  void	   * value );

int srv_revert_to_self( SRV_PROC * srvproc );

char* srv_rpcdb(SRV_PROC* srvproc,int* len );
char* srv_rpcname(SRV_PROC * srvproc,int* len );
int srv_rpcnumber( SRV_PROC * srvproc );
USHORT srv_rpcoptions( SRV_PROC * srvproc );
char* srv_rpcowner( SRV_PROC * srvproc,int	  * len );

int srv_run( SRV_SERVER * server );

int
     srv_sendmsg( SRV_PROC  * srvproc,
						int	        msgtype,
						long int	    msgnum,
						BYTE   msgclass,
						BYTE   state,
						char	  * rpcname,
						int	        rpcnamelen,
						USHORT linenum,
						char	  * message,
						int	        msglen );

int
     srv_ansi_sendmsg( SRV_PROC  * srvproc,
						int	        msgtype,
						long int	    msgnum,
						BYTE   msgclass,
						BYTE   state,
						char	  * rpcname,
						int	        rpcnamelen,
						USHORT linenum,
						char	  * message,
						int	        msglen );

int srv_sendstatus( SRV_PROC * srvproc,long int	  status );


int srv_setuserdata(SRV_PROC* srvproc,void* ptr);


char* srv_sfield( SRV_SERVER * server,int field,int* len);

char* srv_symbol(int	type,int symbol,int* len);

int srv_tdsversion(SRV_PROC* srvproc);

int srv_writebuf(SRV_PROC* srvproc, void* ptr, WORD	count);

BOOL srv_willconvert(int srctype,int desttype );

void srv_ackattention( SRV_PROC * srvproc );

int srv_terminatethread( SRV_PROC * srvproc );

int srv_sendstatistics( SRV_PROC * srvproc );

int srv_clearstatistics( SRV_PROC * srvproc );

int srv_setevent( SRV_SERVER * server, int          event);

int srv_message_handler( SRV_PROC * srvproc,
								int        errornum,
								BYTE       severity,
								BYTE       state,
								int        oserrnum,
								char     * errtext,
								int        errtextlen,
								char     * oserrtext,
								int        oserrtextlen );

int srv_pre_handle( SRV_SERVER * server,
						    SRV_PROC   * srvproc,
						    long int event,
						    EventHandler handler,
						    BOOL         remove );
int srv_post_handle( SRV_SERVER * server,
							 SRV_PROC   * srvproc,
							 long int        event,
							 EventHandler handler,
							 BOOL         remove );

int srv_post_completion_queue( SRV_PROC * srvproc,
									  char   * inbuf,
									  int	     inbuflen );

int srv_IgnoreAnsiToOem( SRV_PROC * srvproc,BOOL bTF);
#endif

%SS_MAJOR_VERSION    = 7
%SS_MINOR_VERSION    = 00
%SS_LEVEL_VERSION    = 0000
$SS_MINIMUM_VERSION  = "7.00.00.0000"
'%ODS_VERSION			((SS_MAJOR_VERSION << 24)  | (SS_MINOR_VERSION << 16))

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'  __GetXpVersion
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
function GetXpVersion alias "__GetXpVersion" export as Dword

   Dim dwMaj as Dword
   Dim dwMin as Dword

   dwMaj = %SS_MAJOR_VERSION
   shift left dwMaj, 24

   dwMin = %SS_MINOR_VERSION
   shift left dwMin, 16

   Function = dwMaj or dwMin

end function
#endif
